% Thomas Algorithm for tridiagonal system of equations of the form [a][x] = [b]
% By SR
% n - length of vector b / rows/columns of a square matrix a
% 
%

function x = Thomas_Algorithm_Func(a,b)

n = length(b);

for i = 1:n
    for j = 1:n
        if i == j
            d(i) = a(i,j);
        elseif i == j+1
            l(i) = a(i,j);
        elseif i == j-1
            u(i) = a(i,j);
        end
    end
end


u(n) = 0;
d = d';
l = l';
u = u';
new = [ l d u ];

for i = 2:n
    d(i) = d(i) - (l(i)/d(i-1))*u(i-1);
    b(i) = b(i) - (l(i)/d(i-1))*b(i-1);
end

x(n) = b(n)/d(n);

for k = 1:n-1
    i = n-k;
    x(i) = (b(i) - u(i)*x(i+1))/d(i);
end

