% Explicit Euler Method to solve system of ODEs
% y1' = f1(t,y1, y2)
% y2' = f2(t,y1, y2)
% y1_n+1 = y1_n + delta_x*fn1
% y2_n+1 = y2_n + delta_x*fn2

% dy1/dx = - 0.5 * y1
% dy2/dx = 4 - 0.3 * y2 - 0.1 * y1
% Numerically integrate above from x = 0 to x = 4 using step size of 0.5
% IC: y1(x=0) = 4;  y2(x=0) = 6;
% y1exact =   ;
% y2exact =   ;

clear
clc
clf

% Initial Values and time step
a = 0; % Lower limit of Integration 
b = 2; % Upper limit of Integration 
delta_x = 0.05;
y1(1) = 4;
y2(1) = 6;
n = (b-a)/delta_x + 1; % no. of points

% Solution
x(1) = 0;
func1 = @(y1) -0.5 * y1 % function to integrate
func2 = @(y1, y2) 4 - 0.3 * y2 - 0.1 * y1 % function to integrate
% func_exact = @(x)  ;

for i = 1:n-1
    x(i+1) = i*delta_x;
    y1(i+1) = y1(i) + delta_x * feval(func1,y1(i));
    y2(i+1) = y2(i) + delta_x * feval(func2,y1(i), y2(i));
end
x
y1
y2

%{
yexact(1) = feval(func_exact,x(1));
for i = 1:n-1
    x(i+1) = i*delta_x;
    yexact(i+1) = feval(func_exact,x(i+1));
end
%}

plot(x, y1, x, y2)
title("Plot of x vs y1 & y2 - Explicit Euler");
grid on
xlabel ("x")
ylabel ("y1, y2")
legend('y1','y2')





