% Modified Euler Predictor - Corrector Method to Solve ODE
% y' = f(x,y)
% y_n+1_P = y_n + delta_x*fn - Predictor
% y_n+1_C = yn + (1/2)*delta_x*(fn + fn+1_P) - Corrector


% dy/dx = -2 * x^3 + 12 * x^2 - 20 * x + 8.5
% Numerically integrate above from x = 0 to x = 4 using step size of 0.5
% IC: y(x=0) = 1;
% yexact = -0.5 * x^4 + 4 * x^3 -10 * x^2 + 8.5 * x + 1;

clear
clc
clf

% Initial Values and time step
a = 0; % Lower limit of Integration 
b = 4; % Upper limit of Integration 
delta_x = 0.05; % h = delta_x, eg 0.5, 0.05
y(1) = 1;
n = (b-a)/delta_x + 1; % no. of points

% Solution
x(1) = 0;
fun = @(x) -2 * x^3 + 12 * x^2 - 20 * x + 8.5;  % function to integrate
func_exact = @(x) -0.5 * x^4 + 4 * x^3 -10 * x^2 + 8.5 * x + 1;

for i = 1:n-1
    x(i+1) = i*delta_x;
    yP(i+1) = y(i) + delta_x * feval(fun,x(i))
    yC(i+1) = y(i) + (1/2) * delta_x * (feval(fun,x(i)) + feval(fun,x(i+1)))
    y(i+1) = yC(i+1);
end
x
y

yexact(1) = feval(func_exact,x(1));
for i = 1:n-1
    x(i+1) = i*delta_x;
    yexact(i+1) = feval(func_exact,x(i+1));
end
yexact

plot(x, y, x, yexact)
title("Plot of x vs y & yexact - Modified Euler Method");
grid on
xlabel ("x")
ylabel ("y, yexact")
legend('y','yexact')



